/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.panel.BlockNumberChangePanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.udf.WiringDiagramUDF;
import java.awt.Component;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MarkerPanel
extends BlockNumberChangePanel {
    private JLabel[] fLblAddtional;

    public MarkerPanel() {
    }

    public MarkerPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
    }

    public void setLabels() {
        this.lBlockNumber.setText(Language.getString("dialog.parameter.marker.markerNumber", "Marker number:"));
        try {
            Block block = ((BlockParameter)this.fParameterReference).getBlock();
            if (!block.getNumberPrefix().equals("M")) {
                return;
            }
            this.fHelpLabel.setText(" ");
            if (block.getWiringDiagram() instanceof WiringDiagramUDF) {
                return;
            }
            this.initLabels();
            this.fLblAddtional[0].setText("M8 = " + Language.getString("block.Marker.startupFlag", "Initialization Flag"));
            this.fLblAddtional[1].setText("M25 = " + Language.getString("block.Marker.OnBoardLCD", "On board LCD backlight"));
            this.fLblAddtional[2].setText("M26 = " + Language.getString("block.Marker.TDLCD", "Logo!TD LCD backlight"));
            this.fLblAddtional[3].setText("M27 = " + Language.getString("block.Marker.MsgLanguage", "Message Language Flag"));
            int markerCount = block.getHardware().getMaxResource(10);
            this.fLblAddtional[0].setVisible(markerCount >= 8);
            this.fLblAddtional[1].setVisible(markerCount >= 25);
            this.fLblAddtional[2].setVisible(markerCount >= 26);
            this.fLblAddtional[3].setVisible(markerCount >= 27);
        }
        catch (Exception e) {
            System.out.println("Error occur in MarkerPanel.");
        }
    }

    private void initLabels() {
        if (this.fLblAddtional == null) {
            this.fLblAddtional = new JLabel[4];
            JPanel panel = (JPanel)this.fHelpLabel.getParent();
            JPanel panelNew = new JPanel();
            panelNew.setLayout(new BoxLayout(panelNew, 1));
            panel.add((Component)panelNew, "South");
            for (int i = 0; i < this.fLblAddtional.length; ++i) {
                this.fLblAddtional[i] = new JLabel();
                panelNew.add(this.fLblAddtional[i]);
            }
        }
    }

    public String getHelpIdString() {
        return "block.Marker";
    }
}

